    # **smyApps4.2authtime接口说明文档 V1.0**



## 1.  RESTful API 设计规范与约定说明

### 1.1  **路径规则（Endpoint rule）**

路径又称"终点"（endpoint），表示API的具体网址。

在RESTful架构中，每个网址代表一种资源（resource），所以网址中不能有动词，只能有名词，而且所用的名词往往与数据库的表格名对应。一般来说，数据库中的表都是同种记录的"集合"（collection），所以API中的名词也应该使用复数。

举例来说，有一组API分别提供Document、表单、视图的信息，则它的路径应该设计成下面这样。

```
-   https://api.example.com/runtime/documents

-   https://api.example.com/runtime/forms

-   https://api.example.com/runtime/views
```

以上路径规则是面向资源的，对于CRUD操作是非常友好的，但是面向一些“动作”或“行为”等一些不符合CRUD的服务请求（如操作按钮的运行执行前脚本），单纯的面向资源的路径构建规则就会让人困惑了。

这种情况我们可以以“子资源”来对待（资源后面加行为动词），例如:GitHub上，对一个gists加星操作：

```
PUT /gists/:id/star
```

并且取消星操作：

```
DELETE /gists/:id/star
```

举例来说，有一组API分别提供执行操作按钮的执行前、执行后脚本和业务处理行为，则它的路径应该设计成下面这样。

```
-   https://api.example.com/runtime/activitys/{id}/excute

-   https://api.example.com/runtime/activitys/{id}/beforactionscript

-   https://api.example.com/runtime/activitys/{id}/afteractionscript
```

### 1.2  **HTTP动词 (Http method)**

对于资源的具体操作类型，由HTTP动词表示。

常用的HTTP动词有下面五个（括号里是对应的SQL命令）。

```
-   GET（SELECT）：从服务器取出资源（一项或多项）。

-   POST（CREATE）：在服务器新建一个资源。

-   PUT（UPDATE）：在服务器更新资源（客户端提供改变后的完整资源）。

-   PATCH（UPDATE）：在服务器更新资源（客户端提供改变的属性）。

-   DELETE（DELETE）：从服务器删除资源。
```

下面是一些例子。

```
-   GET /runtime/documents：获取Document集合

-   POST /runtime/documents：新建一个Document

-   GET /runtime/documents/{id}：获取由ID指定的Document

-   PUT /runtime/documents/{id}：更新由ID指定的Document（客户端提供全部信息，完整更新）

-   PATCH /runtime/documents/{id}：更新由ID指定的Document（客户端提供部分信息，局部更新）

-   DELETE /runtime/documents/{id}：删除由ID指定的Document
```

### 1.3  **过滤信息（Filtering）**

如果记录数量很多，服务器不可能都将它们返回给用户。API应该提供参数，过滤返回结果。

下面是一些常见的参数。

```
-   ?_page=2&_page_lines=30：指定第几页，以及每页的记录数。

-   ?_sortby=name&_order=asc：指定返回结果按照哪个属性排序，以及排序顺序。

-   ?form_type =1：指定筛选条件。
```

参数的设计允许存在冗余，即允许API路径和URL参数偶尔有重复。比如，

```
GET /runtime/documents/{id}/flowhis
```

 与 

```
GET /runtime/flowhis?doc_id={id}
```

的含义是相同的。

### 1.4 **状态码（Status codes）**

------

服务器向用户返回的状态码和提示信息，常见的有以下一些（方括号中是该状态码对应的HTTP动词）。

下面是一些常见的状态码。

```
-   200 OK - [GET]：服务器成功返回用户请求的数据，该操作是幂等的（Idempotent）。

-   201 CREATED - [POST/PUT/PATCH]：用户新建或修改数据成功。

-   202 Accepted - [\*]：表示一个请求已经进入后台排队（异步任务）

-   204 NO CONTENT - [DELETE]：用户删除数据成功。

-   400 INVALID REQUEST -
    [POST/PUT/PATCH]：用户发出的请求有错误，服务器没有进行新建或修改数据的操作，该操作是幂等的。

-   401 Unauthorized - [\*]：表示用户没有权限（令牌、用户名、密码错误）。

-   403 Forbidden - [\*] 表示用户得到授权（与401错误相对），但是访问是被禁止的。

-   404 NOT FOUND -
    [\*]：用户发出的请求针对的是不存在的记录，服务器没有进行操作，该操作是幂等的。

-   406 Not Acceptable -
    [GET]：用户请求的格式不可得（比如用户请求JSON格式，但是只有XML格式）。

-   410 Gone -[GET]：用户请求的资源被永久删除，且不会再得到的。

-   422 Unprocesable entity - [POST/PUT/PATCH]
    当创建一个对象时，发生一个验证错误。

-   500 INTERNAL SERVER ERROR -
    [\*]：服务器发生错误，用户将无法判断发出的请求是否成功。
    
-  4001 INTERNAL SERVER ERROR -
    [\*]：服务器校验错误
```

### 1.5  **错误处理（Error handling）**

就像html错误页面能够显示错误信息一样，API
也应该能返回可读的错误信息，它应该和一般的资源格式一致。

- API应该始终返回相应的状态码，以反映服务器或者请求的状态。
- API的错误码可以分为两部分，400系列和500系列，400系列表明客户端错误：如错误的请求格式等。500系列表示服务器错误。
- API应该至少将所有的400系列的错误以JSON形式返回。如果可能500系列的错误也应该如此。
- JSON格式的错误应该包含以下信息：一个有用的错误信息，一个唯一的错误码，以及任何可能的详细错误描述。如下：

```
{
  "errcode" : 40035,
  "errmsg" : "不合法的参数"
}

```

- 对PUT,POST,PATCH的输入的校验也应该返回相应的详细错误信息，例如：

```
{  
          "errcode" : 40035,  
          "errmsg" : "Validation Failed",  
          "errors" : [
            {  
              "errcode" : 1234,  
              "field" : "first_name",  
              "errmsg" : "First name cannot have fancy characters"  
            },  
            {  
               "errcode" : 1234,  
               "field" : "password",  
               "errmsg" : "Password cannot be blank"  
            }  
          ]  
        }

```

### 1.6 **数据结构（Data structure）**

- 在POST,PUT,PATCH上使用JSON作为输入。
- 注意使用JSON传输的时候，要求请求头里面加入：Content-Type：applicatin/json.否则抛出415异常（unsupported
  media type）。
- 服务器返回的数据格式，统一使用JSON作为输出。

> 服务器返回的JSON数据结构统一如下：

```
{
  "errcode" : 0,
  "errmsg" : "some message",
  "data" : {},
  "errors" : []
}

```

> 参数说明：

| 参数    | 必须 | 说明                 |
| ------- | ---- | -------------------- |
| errcode | 是   | 状态码/返回码        |
| errmsg  | 是   | 消息                 |
| data    | 是   | 服务端返回的数据对象 |
| errors  | 否   | 详细错误信息         |

### 1.7 **其他**

------

1. 客户端控制服务端是否需要返回数据、且返回哪些数据的约定
2. Urls命名规则统一使用蛇形命名法（下划线和小写）





## 1.特权用户管理**

### 1.1查询特权用户列表

**请求方式：** GET  
**请求地址：** /api/authtime/superuser?name={name}&loginno={loginno}&currpage={currpage}&pagelines={pagelines}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|          |          |          |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "id": "Ai6hllhNjS2ull9TKGb",
                "name": "Admin",
                "domains": ["dfv34fjSzxcTKGb","3f4fllzxc2dfvlfvdb"],
                "applications": ["vzefgbtyddfvd","mdciouvrzvby"],
                "loginno": "admin",
                "loginpwd": "3e2708abc7e6158d446248d0d89cf6519ca9fec29b4e2384248e8554d394f1b4",
                "email": "383838@qq.com",
                "status": 1,
                "superAdmin": true,
                "domainAdmin": true,
                "developer": true,
                "secret": null
            }
        ],
        "pageCount": 1
    }
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 返回结果                 |



### 1.2保存特权用户信息

**请求方式：** PUT
**请求地址：** /api/authtime/superuser/{id}

**参数说明：**

| **参数** | **必须** | **说明**   |
| -------- | -------- | ---------- |
| id       | 是       | 特权用户id |

**请求包体**：

```
{

    "name": "名字",

    "loginno": "登陆名",

    "password": "密码",

    "email": "email",

    "status": "状态（int类型 1为激活，0为不激活）",

    "issuperadmin": "是否超级管理员（boolean类型 true为是）",

    "isdeveloper": "是否开发者（boolean类型 true为是）",
    
    "isdomainadmin": "是否企业域管理员（boolean类型 true为是）",
    
    "domains": ["企业域id"],

	"applications": ["软件id"]
}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 返回结果                 |



### 1.3新建特权用户

**请求方式：** POST
**请求地址：** /api/authtime/superuser

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|          |          |          |

**请求包体**：

```
{

    "name": "名字",

    "loginno": "登陆名",

    "password": "密码",

    "email": "email",

    "status": "状态（int类型 1为激活，0为不激活）",

    "issuperadmin": "是否超级管理员（boolean类型 true为是）",

    "isdeveloper": "是否开发者（boolean类型 true为是）",
    
    "isdomainadmin": "是否企业域管理员（boolean类型 true为是）",
    
    "domains": ["企业域id"],

	"applications": ["软件id"]

}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 返回结果                 |





### 1.4删除特权用户

**请求方式：** DELETE
**请求地址：** /api/authtime/

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|          |          |          |

**请求包体**：

```
[
    "ID1",
    "ID2",
    "ID3"
]
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 返回结果                 |

## 2.  **系统管理**

### 2.1获取配置信息

**请求方式：** GET  
**请求地址：** /api/authtime/config

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|          |          |          |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"authConfig": {
			"adDefaultDomain": "",
			"adDomainController": "",
			"adadminloginno": "",
			"adadminloginnopw": "",
			"adjespapassword": "",
			"adjespausernmae": "",
			"adlogindomain": "",
			"authType": "default",
			"casLoginUrl": "http://localhost:8080/obpm-cas/login",
			"casUrlPrefix": "http://localhost:8080/obpm-cas",
			"ldaptLogin": false,
			"localServerName": "localhost:8080",
			"loginAuth": "cn.myapps.security.sso.autherticator.DefaultLoginAuthenticator",
			"smsAffectMode": "all",
			"smsAuthenticate": "false",
			"smsContent": "您正在登陆myApps管理平台，请确认输入短信校验码：$后才能登陆系统。详询020-383804",
			"smsEndRangeIp": "192.168.0.255",
			"smsStartRangeIp": "192.168.0.1",
			"smsTimeout": "100",
			"ssoAuth": "cn.myapps.security.sso.CasUserSSO",
			"ssoDataEncryption": "base64",
			"ssoDefaultEmail": "sso@user",
			"ssoDefaultPassword": "sso",
			"ssoKeyDomain": "obpmDomainName",
			"ssoKeyEmail": "obpmUserEmail",
			"ssoKeyLoginAccount": "obpmLoginAccount",
			"ssoKeyPassword": "obpmLoginPassword",
			"ssoLogoutRedirect": "http://localhost:8080/obpm-cas/logout",
			"ssoRedirect": "http://localhost:8080/obpm/portal/login/sso.action",
			"ssoSaveType": "cookie",
			"usbkeyAffectMode": "all",
			"usbkeyAuthenticate": "false",
			"usbkeyRangeIps": "[{startIP:'192.168.0.1',endIP:'192.168.0.100'},]"
		},
		"ldapConfig": {
			"baseDN": "dc=teemlink,dc=com",
			"deptClass": "organizationalUnit",
			"dirStructure": "uid=?,ou=user,o=?",
			"domain": "demo1",
			"email_": "mail",
			"enterDept": "ou=ceshi",
			"id_": "entryUUID",
			"loginno_": "userprincipalname",
			"loginpwd_": "userPassword",
			"manager": "cn=Administrator,cn=Users,dc=teemlink,dc=com",
			"managerPassword": "teemlink",
			"name_": "cn",
			"pooled": "true",
			"telephone_": "telephoneNumber",
			"url": "ldap://192.168.0.132:389/dc=teemlink,dc=com",
			"userClass": "organizationalPerson",
			"validBaseDN": false,
			"validDirStructure": true
		},
		"imConfig": {
			"ip": "",
			"loginno": "",
			"open": "",
			"password": "",
			"port": ""
		},
		"hxImConfig": {
			"app_name": "com-tlin-jarod-tlin",
			"client_id": "YXA6kqOBEMNtEeeKPC1YpoCz-A",
			"client_secret": "YXA6-2HmjGsEQutF62F5CviM4jqWsVo",
			"grant_type": "client_credentials",
			"open": "0",
			"org_name": "1180171101178675"
		},
		"checkoutConfig": {
			"invocation": false
		},
		"loginConfig": {
			"failLoginTimes": "20",
			"legal": "0",
			"length": "6",
			"maxAge": "60",
			"maxUpdateTimes": "10",
			"noticeAuthor": "1",
			"noticeContent": "欢迎使用myApps平台",
			"noticeMethod": "1",
			"noticeTime": "45"
		}
	}
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 返回结果                 |

### 2.2保存系统配置

**请求方式：** PUT
**请求地址：** /api/authtime/superuser/{id}

**参数说明：**

| **参数** | **必须** | **说明**   |
| -------- | -------- | ---------- |
| id       | 是       | 特权用户id |

**请求包体**：

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"authConfig": {
			"adDefaultDomain": "",
			"adDomainController": "",
			"adadminloginno": "",
			"adadminloginnopw": "",
			"adjespapassword": "",
			"adjespausernmae": "",
			"adlogindomain": "",
			"authType": "default",
			"casLoginUrl": "http://localhost:8080/obpm-cas/login",
			"casUrlPrefix": "http://localhost:8080/obpm-cas",
			"ldaptLogin": false,
			"localServerName": "localhost:8080",
			"loginAuth": "cn.myapps.security.sso.autherticator.DefaultLoginAuthenticator",
			"smsAffectMode": "all",
			"smsAuthenticate": "false",
			"smsContent": "您正在登陆myApps管理平台，请确认输入短信校验码：$后才能登陆系统。详询020-383804",
			"smsEndRangeIp": "192.168.0.255",
			"smsStartRangeIp": "192.168.0.1",
			"smsTimeout": "100",
			"ssoAuth": "cn.myapps.security.sso.CasUserSSO",
			"ssoDataEncryption": "base64",
			"ssoDefaultEmail": "sso@user",
			"ssoDefaultPassword": "sso",
			"ssoKeyDomain": "obpmDomainName",
			"ssoKeyEmail": "obpmUserEmail",
			"ssoKeyLoginAccount": "obpmLoginAccount",
			"ssoKeyPassword": "obpmLoginPassword",
			"ssoLogoutRedirect": "http://localhost:8080/obpm-cas/logout",
			"ssoRedirect": "http://localhost:8080/obpm/portal/login/sso.action",
			"ssoSaveType": "cookie",
			"usbkeyAffectMode": "all",
			"usbkeyAuthenticate": "false",
			"usbkeyRangeIps": "[{startIP:'192.168.0.1',endIP:'192.168.0.100'},]"
		},
		"ldapConfig": {
			"baseDN": "dc=teemlink,dc=com",
			"deptClass": "organizationalUnit",
			"dirStructure": "uid=?,ou=user,o=?",
			"domain": "demo1",
			"email_": "mail",
			"enterDept": "ou=ceshi",
			"id_": "entryUUID",
			"loginno_": "userprincipalname",
			"loginpwd_": "userPassword",
			"manager": "cn=Administrator,cn=Users,dc=teemlink,dc=com",
			"managerPassword": "teemlink",
			"name_": "cn",
			"pooled": "true",
			"telephone_": "telephoneNumber",
			"url": "ldap://192.168.0.132:389/dc=teemlink,dc=com",
			"userClass": "organizationalPerson",
			"validBaseDN": false,
			"validDirStructure": true
		},
		"imConfig": {
			"ip": "",
			"loginno": "",
			"open": "",
			"password": "",
			"port": ""
		},
		"hxImConfig": {
			"app_name": "com-tlin-jarod-tlin",
			"client_id": "YXA6kqOBEMNtEeeKPC1YpoCz-A",
			"client_secret": "YXA6-2HmjGsEQutF62F5CviM4jqWsVo",
			"grant_type": "client_credentials",
			"open": "0",
			"org_name": "1180171101178675"
		},
		"checkoutConfig": {
			"invocation": false
		},
		"loginConfig": {
			"failLoginTimes": "20",
			"legal": "0",
			"length": "6",
			"maxAge": "60",
			"maxUpdateTimes": "10",
			"noticeAuthor": "1",
			"noticeContent": "欢迎使用myApps平台",
			"noticeMethod": "1",
			"noticeTime": "45"
		}
	}
}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 返回结果                 |





### 2.3系统配置导入

**请求方式：** POST  
**请求地址：** /api/authtime/config/import

**参数说明：**

| **参数** | **必须** | **说明**                                     |
| -------- | -------- | -------------------------------------------- |
| path     | 是       | 上传文件的相对路径（14.1上传之后返回的路径） |

请求包体**：

```
{
    "path": "/uploads/lib/icon/upload/sysConfig.xml"
}
```



**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "导入成功"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 企业域集合               |





### 2.4系统配置导出

**请求方式：** GET  
**请求地址：** /api/authtime//export

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|          |          |          |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "导出成功"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 企业域集合               |



### 2.5清除冗余数据

**请求方式：** GET  
**请求地址：** /api/authtime//cleardatas?applicationid={applicationid}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationid | 否       | 软件id   |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "清除成功"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 企业域集合               |



### 2.6清除冗余数据

**请求方式：** GET  
**请求地址：** /api/authtime/clearcache

|      |      |      |
| ---- | ---- | ---- |
|      |      |      |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "清除成功"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 企业域集合               |

### 2.7优化索引

**请求方式：** GET  
**请求地址：** /api/authtime/domain/application/{applicationid}/optimization

|      |      |      |
| ---- | ---- | ---- |
|      |      |      |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "优化完成"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 企业域集合               |

### 2.8同步环信用户

**请求方式：** GET  
**请求地址：** /api/authtime/userstohx

| **参数说明：** |          |          |
| -------------- | -------- | -------- |
| **参数**       | **必须** | **说明** |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "同步成功"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 企业域集合               |

### 2.9清除缓存数据

**请求方式：** POST  
**请求地址：** /api/authtime/config/clearcache

| **参数说明：** |          |          |
| -------------- | -------- | -------- |
| **参数**       | **必须** | **说明** |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "清除成功"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 提示信息                 |

### 2.10获取清除缓存数据状态

**请求方式：** GET  
**请求地址：** /api/authtime/config/clearcache/status

| **参数说明：** |          |          |
| -------------- | -------- | -------- |
| **参数**       | **必须** | **说明** |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "清除成功"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 提示信息                 |

### 2.11同步数据表单

**请求方式：** POST  
**请求地址：** /api/runtime/synchronization/forms

| **参数说明：** |          |          |
| -------------- | -------- | -------- |
| **参数**       | **必须** | **说明** |
| applicationId  | 是       | 软件id   |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "同步成功"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 提示信息                 |

### 2.12获取同步表单状态

**请求方式：** GET  
**请求地址：** /api/runtime/synchronization/forms/status

| **参数说明：** |          |          |
| -------------- | -------- | -------- |
| **参数**       | **必须** | **说明** |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "同步成功"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 提示信息                 |

### 

## 3.  **在线用户**
### 3.1.获取在线用户
**请求方式：** GET  
**请求地址：** /api/authtime/onlines？currpage={currpage}&pagelines={pagelines}&domainid={domainid}

**参数说明：**

| **参数**                 | **必须** | **说明** |
| ------------------------ | -------- | -------- |
| domainid（全部时传空的） | 否       | 软件id   |



**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "linesPerPage": 10,
        "pageCount": 1,
        "datas": [
            {
                "loginTime": "2019-11-13T05:41:07.161+0000",
                "name": "大间谍",
                "mobile": "18877492254",
                "id": "zPsp2hk7CEwtqeMCwtj",
                "loginNo": "admin1",
                "email": "17122237751@qq.com"
            }
        ],
        "rowCount": 1,
        "pageNum": 1
    }
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 企业域集合               |

### 3.2.移除在线用户
**请求方式：** DELETE  
**请求地址：** /api/authtime/onlines/{userId}

**参数说明：**

| **参数**                 | **必须** | **说明** |
| ------------------------ | -------- | -------- |
| userId | 是    | 用户id   |



**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

## 4、jamon

### 4.1获取jamon下菜单页面数据

**请求方式：** GET  
**请求地址：** /api/authtime/jamon/menu

**参数说明：**

| **参数**  | **必须** | **说明**  |
| --------- | -------- | --------- |
| enableAll | 否       | enableAll |



**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"Exception Summary": "Exception Summary = disabled",
		"ExceptionBufferSize": 50,
		"isExceptionDetailEnabled": "disabled",
		"JAMon": "JAMon = disabled",
		"isSQLDetailEnabled": "disabled",
		"SQLBufferSize": 100,
		"SQL Summary": "SQL Summary = disabled",
		"version": "2.7",
		"Interface": "Interface = disabled"
	}
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 返回数据集               |

### 4.2获取jamon下jamonAdmin页面数据

**请求方式：** POST
**请求地址：** /api/authtime/jamon/jamonAdminInfo

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| content  | 是       | 请求包体 |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"dataList": {
			"listHeader": ["Modify", "Label", "Hits", "Avg", "Total", "StdDev", "LastValue", "Min", "Max", "Active", "AvgActive", "MaxActive", "FirstAccess", "LastAccess", "Enabled", "Primary", "HasListeners"],
			"list": [
				[1, "MonProxy-SQL-Type: All, ms.", 14.0, 168.14285714285714, 2354.0, 582.2822283108025, 5.0, 2.0, 2189.0, 0.0, 1.0, 1.0, "2019-11-15T02:49:26.548+0000", "2019-11-15T05:31:58.157+0000", "true", "false", "false"],
				[2, "com.fdsapi.arrays.ArrayFilter.filter(Object[][]), ms.", 20.0, 1.8, 36.0, 2.9127668163304437, 0.0, 0.0, 10.0, 0.0, 1.0, 1.0, "2019-11-15T02:52:39.978+0000", "2019-11-15T04:05:12.542+0000", "true", "false", "false"]
			]
		},
		"debugStr": ""
	}
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 返回数据集               |

## 5.  **swagger**
### 5.1.根据角色获取用户（选用户之前要先选企业域，然后把企业域id传过来）
**请求方式：** GET  
**请求地址：** /api/authtime/swagger/getuserlistbyrole？currpage={currpage}&pagelines={pagelines}&roleid={roleid}&domainid={domainid}

**参数说明：**

| **参数**                 | **必须** | **说明** |
| ------------------------ | -------- | -------- |
| roleid | 是       | 软件id   |
| domainid | 是       | 企业域id   |



**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "domainid": "3CffNlgt9B9StIjIUPB",
                "id": "__MwV7Ama2EPx6CfoZgCk",
                "name": "lee9999",
                "nameLetter": "lee9999",
                "loginno": "lee9999",
                "loginpwd": "58c6c2cd643ca409a6e36ee45b47f6d2384511b72e1ab2b2",
                "email": null,
                "calendarType": "HmKdJTD3m76sGFo45Ob",
                "status": 0,
                "telephone": null,
                "superAdmin": false,
                "developer": false,
                "defaultApplication": null,
                "defaultDepartment": null,
                "domainPermission": 0,
                "superior": null,
                "startProxyTime": null,
                "endProxyTime": null,
                "passwordArray": null,
                "lockFlag": 1,
                "publicKey": null,
                "avatar": null,
                "favoriteContacts": null,
                "liaisonOfficer": false,
                "permissionType": "private",
                "telephone2": null,
                "telephonePublic": true,
                "telephonePublic2": true,
                "emailPublic": true,
                "userInfoPublic": true,
                "signs": null,
                "level": 0,
                "roles": [
                    {
                        "id": "kPLbeydkgiYW6NIkCt0",
                        "name": "主管",
                        "roleNo": "1002",
                        "status": 1,
                        "defaultRole": true,
                        "sortId": null,
                        "permission": null
                    },
                    {
                        "id": "2jSs6cnzu4mzY9C13vF",
                        "name": "员工",
                        "roleNo": "5",
                        "status": 1,
                        "defaultRole": true,
                        "sortId": null,
                        "permission": null
                    },
                    {
                        "id": "jkpTHKg7DpuXQrppVxx",
                        "name": "测试",
                        "roleNo": "1001",
                        "status": 1,
                        "defaultRole": false,
                        "sortId": null,
                        "permission": null
                    },
                    {
                        "id": "2ytUeoxBqghwofmBALl",
                        "name": "办公室",
                        "roleNo": "1005",
                        "status": 1,
                        "defaultRole": true,
                        "sortId": null,
                        "permission": null
                    },
                    {
                        "id": "0Q0LkJpfR1ejtO8rD3p",
                        "name": "人事",
                        "roleNo": "1004",
                        "status": 1,
                        "defaultRole": true,
                        "sortId": null,
                        "permission": null
                    }
                ],
                "remarks": null,
                "departments": [
                    {
                        "id": "3nvysoo7nWKoxp0FShm",
                        "name": "测试部门",
                        "superior": {
                            "id": "Z42xU8LmniRouZ93E7s",
                            "name": "测试",
                            "superior": null,
                            "code": "1",
                            "level": 0,
                            "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s",
                            "domain": {
                                "id": "3CffNlgt9B9StIjIUPB",
                                "sendHost": null,
                                "sendAddress": null,
                                "sendAccount": null,
                                "sendPassword": null,
                                "ccAddress": null,
                                "isUseClient": null,
                                "functionDomain": null,
                                "trash": null,
                                "sender": null,
                                "draft": null,
                                "removed": null,
                                "fetchServer": null,
                                "fetchServerPort": null,
                                "fetchProtocol": null,
                                "fetchssl": null,
                                "smtpServer": null,
                                "smtpServerPort": null,
                                "smtpAuthenticated": null,
                                "smtpssl": null,
                                "name": "测试1",
                                "systemName": "1111111"
                            },
                            "valid": 1,
                            "orderByNo": 0,
                            "weixinDeptId": "1",
                            "lanxinDeptId": "",
                            "dingdingDeptId": null,
                            "field1": null,
                            "field2": null,
                            "field3": null,
                            "field4": null,
                            "field5": null,
                            "field6": null,
                            "field7": null,
                            "field8": null,
                            "field9": null,
                            "field10": null,
                            "fieldExtendsValues": []
                        },
                        "code": null,
                        "level": 1,
                        "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s_3nvysoo7nWKoxp0FShm",
                        "domain": {
                            "id": "3CffNlgt9B9StIjIUPB",
                            "sendHost": null,
                            "sendAddress": null,
                            "sendAccount": null,
                            "sendPassword": null,
                            "ccAddress": null,
                            "isUseClient": null,
                            "functionDomain": null,
                            "trash": null,
                            "sender": null,
                            "draft": null,
                            "removed": null,
                            "fetchServer": null,
                            "fetchServerPort": null,
                            "fetchProtocol": null,
                            "fetchssl": null,
                            "smtpServer": null,
                            "smtpServerPort": null,
                            "smtpAuthenticated": null,
                            "smtpssl": null,
                            "name": "测试1",
                            "systemName": "1111111"
                        },
                        "valid": 1,
                        "orderByNo": 0,
                        "weixinDeptId": "14",
                        "lanxinDeptId": null,
                        "dingdingDeptId": null,
                        "field1": null,
                        "field2": null,
                        "field3": null,
                        "field4": null,
                        "field5": null,
                        "field6": null,
                        "field7": null,
                        "field8": null,
                        "field9": null,
                        "field10": null,
                        "fieldExtendsValues": []
                    }
                ],
                "userDepartmentRoleSets": [
                    {
                        "id": "4028d0816e67dd06016e67e30e7d0007",
                        "userId": "__MwV7Ama2EPx6CfoZgCk",
                        "roleId": "2jSs6cnzu4mzY9C13vF",
                        "departmentId": "3nvysoo7nWKoxp0FShm"
                    },
                    {
                        "id": "4028d0816e67dd06016e67e30e7d0009",
                        "userId": "__MwV7Ama2EPx6CfoZgCk",
                        "roleId": "jkpTHKg7DpuXQrppVxx",
                        "departmentId": ""
                    },
                    {
                        "id": "4028d0816e67dd06016e67e30e7d000b",
                        "userId": "__MwV7Ama2EPx6CfoZgCk",
                        "roleId": "jkpTHKg7DpuXQrppVxx",
                        "departmentId": "3nvysoo7nWKoxp0FShm"
                    },
                    {
                        "id": "4028d0816e67dd06016e67e30e7d000c",
                        "userId": "__MwV7Ama2EPx6CfoZgCk",
                        "roleId": "0Q0LkJpfR1ejtO8rD3p",
                        "departmentId": ""
                    },
                    {
                        "id": "4028d0816e67dd06016e67e30e7d000a",
                        "userId": "__MwV7Ama2EPx6CfoZgCk",
                        "roleId": "2ytUeoxBqghwofmBALl",
                        "departmentId": ""
                    },
                    {
                        "id": "4028d0816e67dd06016e67e30e7d0008",
                        "userId": "__MwV7Ama2EPx6CfoZgCk",
                        "roleId": "2jSs6cnzu4mzY9C13vF",
                        "departmentId": ""
                    },
                    {
                        "id": "4028d0816e67dd06016e67e30e7d0006",
                        "userId": "__MwV7Ama2EPx6CfoZgCk",
                        "roleId": "kPLbeydkgiYW6NIkCt0",
                        "departmentId": ""
                    }
                ],
                "domainUser": "false",
                "useIM": false,
                "orderByNo": 0,
                "dimission": 0,
                "proxyUser": null,
                "field1": null,
                "field2": null,
                "field3": null,
                "field4": null,
                "field5": null,
                "field6": null,
                "field7": null,
                "field8": null,
                "field9": null,
                "field10": null,
                "pwdErrorTimes": 0,
                "fieldExtendsValues": [],
                "roleDepartments": [
                    {
                        "roleId": "2jSs6cnzu4mzY9C13vF",
                        "roleName": "员工",
                        "applicationId": "HdPeBqYwJyFyjHkhZu3",
                        "departmentName": null,
                        "departmentId": "3nvysoo7nWKoxp0FShm"
                    },
                    {
                        "roleId": "jkpTHKg7DpuXQrppVxx",
                        "roleName": "测试",
                        "applicationId": "HdPeBqYwJyFyjHkhZu3",
                        "departmentName": null,
                        "departmentId": "3nvysoo7nWKoxp0FShm"
                    }
                ],
                "userSkin": null,
                "userStyle": null,
                "useHomePage": null,
                "pendingStyle": null,
                "generalPage": null,
                "configure": null,
                "commonOpinion": null,
                "superiorList": []
            }
        ],
        "pageCount": 1
    }
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 企业域集合               |



### 5.2.登陆

**请求方式：** POST  
**请求地址：** /api/authtime/swagger/login？userid={userid}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| userid   | 是       | 用户id   |
|          |          |          |



**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "登陆成功"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 企业域集合               |





### 5.3.注销

**请求方式：** POST  
**请求地址：** /api/authtime/swagger/logout

**参数说明：**

|      |      |      |
| ---- | ---- | ---- |
|      |      |      |
|      |      |      |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "注销成功"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 企业域集合               |